% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglinear.R
\name{sdc_loglinear}
\alias{sdc_loglinear}
\alias{print.sdc_loglinear}
\alias{plot.sdc_loglinear}
\title{Calculates file-level risk measures using a loglinear model.}
\usage{
sdc_loglinear(
  data,
  weight,
  varpool,
  degree = 2,
  numiter = 40,
  epsilon = 0.001,
  blanks_as_missing = TRUE,
  output_filename = NULL
)

\method{print}{sdc_loglinear}(x, summary_outfile = NULL, ...)

\method{plot}{sdc_loglinear}(x, plotpath = NULL, plotvar1 = character(0), plotvar2 = character(0), ...)
}
\arguments{
\item{data}{Data frame containing the data to be evaluated.}

\item{weight}{Column name for sampling weights.}

\item{varpool}{Vector of column names to be used in model.}

\item{degree}{Highest degree of interaction terms to be used in the model.}

\item{numiter}{Maximum number of iterations to run iterative proportional 
fitting for the loglinear model.}

\item{epsilon}{Maximum deviation allowed between observed and fitted margins.}

\item{blanks_as_missing}{If TRUE, character and factor variables that are
blank or pure whitespace are treated as missing values.}

\item{output_filename}{Name of the csv file to save the data set with 
record-level risk measures, .tau1_rec and .tau2_rec, attached. NULL if no 
output file is to be saved.}

\item{x}{Object of class sdc_loglinear, as returned by sdc_loglinear.}

\item{summary_outfile}{Name of summary output .txt file. If not NULL, console
output is copied to the file. Default is NULL (no logging of output).
Errors and warnings are not diverted (consider running in batch mode if
logging is needed).}

\item{...}{Currently unused. For NextMethod compatibility.}

\item{plotpath}{Directory to save plots. Plots are saved as \emph{jpeg} files 
(quality = 100\%). If the directory does not exist, it is first created.
If \code{plotpath} is NULL (default), plots are not saved.}

\item{plotvar1}{A vector of names of discrete variables for boxplots. If 
none, boxplots are not produced.}

\item{plotvar2}{A vector of names of continuous variables for scatterplots. 
If none, scatterplots are not produced.}
}
\value{
An object of type \code{sdc_loglinear} containing calculated risk
measures.
}
\description{
Calculates file-level risk measures using a loglinear model.
}
\details{
The data should not contain any missing values among \code{varpool}
  variables or the \code{weight} variable.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: S3 print method for sdc_loglinear objects

Prints tables of file-level reidentification risk measures.

\item \code{plot}: S3 plot method for \code{sdc_loglinear} objects

Produces boxplots and scatterplots of record-level risk measures, tau1 and
tau2, of the degree specified in the original call to \code{sdc_loglinear}.
}}

\examples{
data(exampledata)
vars <- c("BORNUSA", "CENREG", "DAGE3", "DRACE3", "EDUC3", "GENDER")
wgt <- "WEIGHT"

results <- sdc_loglinear(exampledata, wgt, vars, degree=3)
print(results)
plot(results, plotvar1="BORNUSA", plotvar2="WEIGHT")
}
