% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedFunctions.R
\name{[.SDEFSR_Rules}
\alias{[.SDEFSR_Rules}
\title{Filter rules in a \code{SDEFSR_Rules} object returning a new \code{SDEFSR_Rules} object}
\usage{
\method{[}{SDEFSR_Rules}(SDEFSR_RulesObject, condition = T)
}
\arguments{
\item{SDEFSR_RulesObject}{The \code{SDEFSR_RulesObject} object to filter}

\item{condition}{Expression to filter the \code{SDEFSR_Rules} object}
}
\description{
Generates a new \code{SDEFSR_Rules} object containing the rules that passed the filter
specified
}
\details{
This functions allows to filter the rule set by a given quality measure. The quality measures 
    that are available are: \code{nVars, Coverage, Unusualness, Significance, FuzzySupport, 
    Support, FuzzyConfidence, Confidence, TPr and FPr}
}
\examples{
library(SDEFSR)
#Apply filter by unusualness
habermanRules[Unusualness > 0.05]

#Also, you can make the filter as complex as you can
#Filter by Unusualness and TPr
habermanRules[Unusualness > 0.05 & TPr > 0.9]


}

