% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_map.R
\name{to_map}
\alias{to_map}
\title{Plot location data on a map}
\usage{
to_map(
  sdata,
  xlim = NULL,
  ylim = NULL,
  margin = 10,
  bgmap = NULL,
  google.key = NULL,
  map.bg = "grey",
  map.col = "black",
  zoom = NULL,
  point.bg = "yellow",
  point.col = "black",
  point.symbol = 21,
  point.size = 1,
  line.col = "lightgrey",
  line.type = 1,
  line.size = 0.5,
  sb.distance = NULL,
  sb.lwd = 1,
  sb.line.col = "black",
  sb.text.size = 4,
  sb.text.col = "black",
  sb.space = 3,
  title = "id",
  title.size = 11,
  axes.text.size = 11,
  axes.lab.size = 11,
  multiplot = TRUE,
  nrow = 1,
  ncol = 1
)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon". 
The function creates a map for each unique "id" (e.g. transmitter number, identifier for each animal). 
"DateTime" is the GMT date & time of each location in class \code{\link[base:DateTimeClasses]{POSIXct}} 
or \code{\link[base]{character}} with the following format "2012-06-03 01:33:46".
"lat" and "lon" are the latitude and longitude of each location in decimal degrees.}

\item{xlim, ylim}{Limits for x and y axes. 
If not specified, the values are determined as the maximum range of the input data plus an additional margin (see \emph{margin}).}

\item{margin}{Set the amount of spaces added around the periphery of the plot. The value is scaled to the plot. 
The smaller value increases the margin.}

\item{bgmap}{A data frame of a background map data, containing the following headers: "long", "lat", "group". 
If not specified, the \code{\link[maps]{world}} map is used. 
Google Maps ("terrain", "satellite", "roadmap", "hybrid") can also be queried.}

\item{google.key}{If Google Maps are queried, a valid API key (a string) needs to be specified here. See \code{\link[ggmap]{register_google}} for details.}

\item{map.bg}{Background colour of the map. This argument is ignored when any Google Maps is selected.}

\item{map.col}{Outline colour of the map. This argument is ignored when any Google Maps is selected.}

\item{zoom}{Map zoom for Google Maps. Default (NULL) to estimate the zoom from each data set. 
For other options, see \code{\link[ggmap]{get_map}} for details.}

\item{point.bg}{The colour to fill in a symbol.}

\item{point.col}{The colour for the outline of a symbol.}

\item{point.symbol}{An integer or a string to specify the symbol type. See \code{\link[ggplot2:aes_linetype_size_shape]{shape}} for details.}

\item{point.size}{An integer to specify the size of the symbol.}

\item{line.col}{The colour of the line that connects consecutive points.}

\item{line.type}{The type of the line that connects consecutive points. See \code{\link[ggplot2:aes_linetype_size_shape]{linetype}} for details.}

\item{line.size}{An integer to specify the thickness (width) of the line that connects consecutive points.}

\item{sb.distance}{An integer to specify the length of the scale bar. If not specified, approximately a quarter of the 
plotting range will be used.}

\item{sb.lwd}{An integer to specify the thickness (width) of the scale bar.}

\item{sb.line.col}{The colour of the scale bar.}

\item{sb.text.size}{An integer to specify the text size for the scale bar.}

\item{sb.text.col}{The colour of the text for the scale bar.}

\item{sb.space}{Set the amount of space between the scale bar and the text. 
The value is scaled to the plot. The smaller value increases the space.}

\item{title}{The main title for each plot. If not specified, the "id" will be used.}

\item{title.size}{An integer to specify the size of the title.}

\item{axes.text.size}{An integer to specify the size of the axes characters.}

\item{axes.lab.size}{An integer to specify the size of the axes labels.}

\item{multiplot}{Logical. If TRUE (default), multiple plots are displayed on the same page.}

\item{nrow}{An integer to specify the number of rows in the multiple plot page.}

\item{ncol}{An integer to specify the number of columns in the multiple plot page.}
}
\value{
An arrangelist is returned when \emph{multiplot} is TRUE. Otherwise a list is returned.
}
\description{
Function to plot tracking data on a map or a satellite image.
}
\examples{
#### Load data sets
## Fastloc GPS data obtained from two green turtles
data(turtle)
data(turtle2)
turtles<-rbind(turtle, turtle2)

#### Filter temporal and/or spatial duplicates
turtle.dup <- dupfilter(turtles, step.time=5/60, step.dist=0.001)
 

#### ddfilter
V <- vmax(turtle.dup)
VLP <- vmaxlp(turtle.dup)
turtle.dd <- ddfilter(turtle.dup, vmax=V, vmaxlp=VLP)


#### Plot filtered data for each animal
## using the low-resolution world map
to_map(turtle.dd, point.size = 2, line.size = 0.5, axes.lab.size = 0, ncol=2, nrow=1)

\dontrun{
## using the high-resolution google satellite images
to_map(turtle.dd, bgmap = "satellite", google.key = "key", ncol=2)
}
}
\seealso{
\code{\link{dupfilter}}, \code{\link{ddfilter}}, \code{\link{vmax}}, \code{\link{vmaxlp}}
}
\author{
Takahiro Shimada
}
