% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxentVarImp.R
\name{maxentVarImp}
\alias{maxentVarImp}
\title{Maxent Variable Importance}
\usage{
maxentVarImp(model)
}
\arguments{
\item{model}{\linkS4class{SDMmodel} or \linkS4class{SDMmodelCV} object
trained using the "Maxent" method.}
}
\value{
A data frame with the variable importance.
}
\description{
Shows the percent contribution and permutation importance of the
environmental variables used to train the model.
}
\details{
When an \linkS4class{SDMmodelCV} object is passed to the function,
the output is the average of the variable importance of each model trained
during the cross validation.
}
\examples{
\donttest{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence locations
p_coords <- condor[, 1:2]

# Prepare background locations
bg_coords <- dismo::randomPoints(predictors, 5000)

# Create SWD object
presence <- prepareSWD(species = "Vultur gryphus", coords = p_coords,
                       env = predictors, categorical = "biome")
bg <- prepareSWD(species = "Vultur gryphus", coords = bg_coords,
                 env = predictors, categorical = "biome")

# Train a Maxent model
model <- train(method = "Maxent", p = presence, a = bg, fc = "l")
maxentVarImp(model)
}
}
\seealso{
\code{\link{maxentTh}}
}
\author{
Sergio Vignali
}
