% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maximin.R
\name{maximin.augment}
\alias{maximin.augment}
\title{Augment a design by adding new design points that minimize the reciprocal distance criterion greedily}
\usage{
maximin.augment(n, p, D.ini, candidate = NULL, r = 2 * p)
}
\arguments{
\item{n}{the size of the final design.}

\item{p}{design dimension.}

\item{D.ini}{initial design.}

\item{candidate}{candidate points to choose from. The default candidates are Sobol points of size 100n.}

\item{r}{the power parameter in the \code{\link{maximin.crit}}. By default it is set as \code{2p}.}
}
\value{
the augmented design.
}
\description{
This function augments a design by adding new design points one-at-a-time that minimize the reciprocal distance criterion.
}
\details{
\code{maximin.augment} augments a design by adding new design points that minimize the reciprocal distance criterion (see \code{\link{maximin.crit}}) greedily. In each iteration, the new design points is selected as the one from the candidate points that has the smallest sum of reciprocal distance to the existing design, that is, \eqn{\bm x_{k+1} = \arg\min_{\bm x} \sum_{i=1}^k \frac{1}{\|\bm x - \bm x_i\|^r}}.
}
\examples{
n.ini = 10
n = 20
p = 3
D.ini = maximinLHD(n.ini, p)$design
D = maximin.augment(n, p, D.ini)
}
