% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean2_ttest.R
\name{mean2.ttest}
\alias{mean2.ttest}
\title{Two-sample Student's t-test for Univariate Means}
\usage{
mean2.ttest(
  x,
  y,
  alternative = c("two.sided", "less", "greater"),
  paired = FALSE,
  var.equal = FALSE
)
}
\arguments{
\item{x}{a length-\eqn{n} data vector.}

\item{y}{a length-\eqn{m} data vector.}

\item{alternative}{specifying the alternative hypothesis.}

\item{paired}{a logical; whether consider two samples as paired.}

\item{var.equal}{a logical; if \code{FALSE}, use Welch's correction.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given two univariate samples \eqn{x} and \eqn{y}, it tests
\deqn{H_0 : \mu_x^2 \left\lbrace =,\geq,\leq \right\rbrace \mu_y^2\quad vs\quad H_1 : \mu_x^2 \left\lbrace \neq,<,>\right\rbrace \mu_y^2}
using the procedure by Student (1908) and Welch (1947).
}
\examples{
\donttest{
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  x = rnorm(57)  # sample x from N(0,1)
  y = rnorm(89)  # sample y from N(0,1)
  
  counter[i] = ifelse(mean2.ttest(x,y)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\n* Example for 'mean2.ttest'\n","*\n",
"* number of rejections   : ", sum(counter),"\n",
"* total number of trials : ", niter,"\n",
"* empirical Type 1 error : ",round(sum(counter/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{student_probable_1908}{SHT}

\insertRef{student_probable_1908a}{SHT}

\insertRef{welch_generalization_1947}{SHT}
}
\concept{mean_univariate}
