% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.survivalplots.R
\name{create.survivalplots}
\alias{create.survivalplots}
\title{Plots Kaplan-meier survival curves}
\usage{
create.survivalplots(
  data.directory = ".",
  output.directory = ".",
  training.datasets = NULL,
  validation.datasets = NULL,
  top.n.features = 25,
  learning.algorithms = c("backward", "forward"),
  truncate.survival = 100,
  survtime.cutoffs = c(seq(5, 10, 1)),
  main.title = FALSE,
  KM.plotting.fun = "create.KM.plot",
  plot.univariate.data = FALSE,
  plot.multivariate.data = TRUE,
  resolution = 100
)
}
\arguments{
\item{data.directory}{Path to the directory containing datasets as specified
by \code{training.datasets}, \code{validation.datasets}}

\item{output.directory}{Path to the output folder where intermediate and
results files were saved}

\item{training.datasets}{A vector containing names of training datasets}

\item{validation.datasets}{A vector containing names of validation datasets}

\item{top.n.features}{A numeric value specifying how many top ranked
features will be used for univariate survival modelling}

\item{learning.algorithms}{A character vector specifying which learning
algorithm to be used for model fitting and feature selection. Defaults to
c('backward', 'forward'). Available options are: c('backward', 'forward',
'glm', 'randomforest')}

\item{truncate.survival}{A numeric value specifying survival truncation in
years. Defaults to 100 years which effectively means no truncation}

\item{survtime.cutoffs}{A vector containing survival cutoff time points to
be used for dichotomization of patients into risk groups for senstivity
analysis}

\item{main.title}{A logical to specify plot's main title. Defaults to FASLE}

\item{KM.plotting.fun}{A string containing the name of the method to use for
plotting KM curves. Defaults to \code{create.KM.plot}}

\item{plot.univariate.data}{Logical to indicate whether to plot univariate
results for all subnetworks. Default to FALSE}

\item{plot.multivariate.data}{Logical to indicate whether to plot
multivariate results for all subnetworks. Defaults to TRUE}

\item{resolution}{A numeric value specifying resolution of the png images of
KM survival curves. Defaults to 100}
}
\value{
The KM survival curves are stored under
\code{output.directory}/graphs/
}
\description{
Plots Kaplan-meier survival curves for all the training & datasets,
independently as well as combined training datasets cohort and validation
datasets cohort. The function also plots KM survival curves for each of the
\code{top.n.features} independently.
}
\examples{

# see package's main documentation

}
\author{
Syed Haider
}
\keyword{Kaplan-meier}
\keyword{survival}
