% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L2_Colony.R
\name{buildUp}
\alias{buildUp}
\title{Build up Colony or MultiColony object by adding (raising) workers and drones}
\usage{
buildUp(
  x,
  nWorkers = NULL,
  nDrones = NULL,
  new = TRUE,
  exact = FALSE,
  resetEvents = FALSE,
  simParamBee = NULL,
  ...
)
}
\arguments{
\item{x}{\code{\link{Colony-class}} or \code{\link{MultiColony-class}}}

\item{nWorkers}{numeric or function, number of worker to add to the colony,
but see \code{new}; if \code{NULL} then \code{\link{SimParamBee}$nWorkers}
is used. If input is \code{\link{MultiColony-class}},
the input could also be a vector of the same length as the number of colonies. If
a single value is provided, the same value will be applied to all the colonies.}

\item{nDrones}{numeric or function, number of drones to add to the colony,
but see \code{new}; if \code{NULL} then \code{\link{SimParamBee}$nDrones}
is used. If input is \code{\link{MultiColony-class}},
the input could also be a vector of the same length as the number of colonies. If
a single value is provided, the same value will be applied to all the colonies.}

\item{new}{logical, should the number of workers and drones be added anew or
should we only top-up the existing number of workers and drones to
\code{nWorkers} and \code{nDrones} (see details)}

\item{exact}{logical, if the csd locus is turned on and exact is \code{TRUE},
create the exact specified number of only viable workers (heterozygous on
the csd locus)}

\item{resetEvents}{logical, call \code{\link{resetEvents}} as part of the
build up}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}

\item{...}{additional arguments passed to \code{nWorkers} or \code{nDrones}
when these arguments are a function}
}
\value{
\code{\link{Colony-class}} or \code{\link{MultiColony-class}} with workers and
   drones replaced or added
}
\description{
Level 2 function that builds up a Colony or MultiColony object by adding
  (raising) workers and drones usually in spring or after events such as split or
  swarming.
}
\details{
This function increases queen's \code{nWorkers}, \code{nHomBrood},
  and \code{nDrones} counters. It also turns production on.

  Argument \code{new} enables simulation of two common cases. First,
  if you are modelling year-to-year cycle, you will likely want
  \code{new = TRUE}, so that, say, in spring you will replace old (from last
  year) workers and drones with the new ones. This is the case that we are
  targeting and hence \code{new = TRUE} is default. Second, if you are
  modelling shorter period cycles, you will likely want \code{new = FALSE} to
  just top up the current workers and drones - you might also want to look at
  \code{\link{replaceWorkers}} and \code{\link{replaceDrones}}.

TODO: Discuss on how to model day-to-day variation with \code{new = FALSE}.
      We are not sure this is easy to achieve with current implementation
      just now, but could be expanded.
      https://github.com/HighlanderLab/SIMplyBee/issues/176
}
\examples{
founderGenomes <- quickHaplo(nInd = 4, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
isProductive(colony)
apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
isProductive(apiary)

# Build up
# Using defaults in SP$nWorkers & SP$nDrones
(colony <- buildUp(colony))
isProductive(colony)
# Build-up a MultiColony class
(apiary <- buildUp(apiary))
isProductive(apiary)

# The user can also specify a function that will give a number
colony <- removeWorkers(colony) # Remove workers to start from fresh
colony <- removeDrones(colony) # Remove drones to start from fresh
buildUp(colony, nWorkers = nWorkersPoisson, nDrones = nDronesPoisson)
buildUp(colony, nWorkers = nWorkersPoisson, nDrones = nDronesPoisson)
# nWorkers and nDrones will vary between function calls when a function is used
# You can store these functions or a values in the SP object
SP$nWorkers <- nWorkersPoisson
SP$nDrones <- nDronesPoisson

# Specifying own number
colony <- buildUp(colony, nWorkers = 100)
# Build up a MultiColony class
apiary <- buildUp(apiary, nWorkers = 250)
# Build up with different numbers
apiary <- buildUp(apiary, nWorkers = c(1000, 2000), nDrones = c(100, 150))
nWorkers(apiary)
nDrones(apiary)

# Queen's counters
getMisc(getQueen(buildUp(colony)))
}
