% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L1_Pop.R
\name{cross}
\alias{cross}
\title{Cross (mate) virgin queen(s) as a population, of a colony, or
  of all given colonies}
\usage{
cross(x, drones, crossPlan = NULL, checkMating = "error", simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link{Pop-class}} or code{\link{Colony-class}} or \code{\link{MultiColony-class}},
one or more virgin queens / colonies to be mated;}

\item{drones}{\code{\link{Pop-class}} or a list of \code{\link{Pop-class}},
group(s) of drones that will be mated with virgin queen(s); if there is
more than one virgin queen, the user has to provide a list of drone
\code{\link{Pop-class}}. For this, the user can use \code{\link{pullDroneGroupsFromDCA}}}

\item{crossPlan, }{named list with names being virgin queen or colony IDs with
each list element holding the IDs of selected drones. Also see
\code{\link{createRandomCrossPlan}}. If cross plan is \code{NULL}, we cross
each virgin queen with the element-wise element of \code{drones}, which
should be the same length as the number of virgin queens If the cross plan
is provided, the \code{drones} argument must be a single \code{\link{Pop-class}}.}

\item{checkMating}{character, throw a warning (when \code{checkMating = "warning"}),
or stop error (when \code{checkMating = "error"}) when some matings fail (see
Details)}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}
}
\value{
\code{\link{Pop-class}} with mated queen(s). The misc slot of the
  queens contains additional information about the number of workers, drones,
  and homozygous brood produced, and the expected percentage of csd homozygous
  brood.
}
\description{
Level 1 function that crosses (mates) a virgin queen to a group
  of drones. The virgin queen(s) could be within a population (\code{\link{Pop-class}}),
  in a colony (\code{\link{Colony-class}}), or multi-colony (\code{\link{MultiColony-class}}).
  This function does not create any progeny, it only stores the mated drones
  (fathers) so we can later create progeny as needed. When input is a
  (\code{\link{Colony-class}}) or  (\code{\link{MultiColony-class}}), one
  virgin queens is selected at random, mated, and promoted to the queen of
  the colony. Other virgin queens are destroyed. Mated drones (fathers) are
  stored for producing progeny at a later stage.
}
\details{
This function changes caste for the mated drones to fathers, and
  mated virgin queens to queens. See examples. This means that you can not
  use these individuals in matings any more!

  If the supplied drone population is empty (has 0 individuals), which
  can happen in edge cases or when \code{\link{nFathersPoisson}} is used
  instead of \code{\link{nFathersTruncPoisson}}, then mating of a virgin
  queen will fail and she will stay virgin. This can happen for just a few
  of many virgin queens, which can be annoying to track down, but you can use
  \code{\link{isQueen}} or \code{\link{isVirginQueen}} to find such virgin
  queens. You can use \code{checkMating} to alert you about this situation.
}
\examples{
founderGenomes <- quickHaplo(nInd = 20, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 200)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 8, nDrones = nFathersPoisson)

# If input is a Pop class of virgin queen(s)
virginQueen1 <- basePop[2]
isQueen(virginQueen1)
(matedQueen1 <- cross(
  x = virginQueen1,
  drones = droneGroups[[1]]
))

isQueen(virginQueen1)
isQueen(matedQueen1)
nFathers(matedQueen1)
isDrone(getFathers(matedQueen1))
isFather(getFathers(matedQueen1))

virginQueen2 <- basePop[3]
(matedQueen2 <- cross(
  x = virginQueen2,
  drones = droneGroups[[2]]
))

isQueen(virginQueen2)
isQueen(matedQueen2)
nFathers(matedQueen2)

matedQueens <- cross(
  x = c(basePop[4], basePop[5]),
  drones = droneGroups[c(3, 4)]
)

isQueen(matedQueens)
nFathers(matedQueens)
getFathers(matedQueens)

# Inbred mated queen (mated with her own sons)
matedQueen3 <- cross(
  x = basePop[1],
  drones = droneGroups[[5]]
)
# Check the expected csd homozygosity
pHomBrood(matedQueen3)

# If input is a Colony or MultiColony class
# Create Colony and MultiColony class
colony <- createColony(basePop[6])
isVirginQueen(getVirginQueens(colony))
apiary <- createMultiColony(basePop[7:8], n = 2)
all(isVirginQueen(mergePops(getVirginQueens(apiary))))

# Cross
colony <- cross(colony, drones = droneGroups[[6]])
isQueenPresent(colony)
apiary <- cross(apiary, drones = droneGroups[c(7, 8)])
all(isQueenPresent(apiary))
nFathers(apiary)

# Try mating with drones that were already used for mating
colony <- createColony(basePop[9])
try((matedColony <- cross(x = colony, drones = droneGroups[[1]])))
# Create new drones and mate the colony with them
drones <- createDrones(x = basePop[1], nInd = 15)
all(isDrone(drones))
any(isFather(drones))
(matedColony <- cross(x = colony, drones = drones))
isQueenPresent(matedColony)

}
\seealso{
\code{\link{Colony-class}} on how we store the fathers along the
  queen.

For crossing virgin queens according to a cross plan, see
  \code{\link{createRandomCrossPlan}}.
  For crossing virgin queens on a mating stations, see
  \code{\link{createMatingStationDCA}}
}
