% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParamBee.R
\name{nDronesPoisson}
\alias{nDronesPoisson}
\alias{nDronesTruncPoisson}
\alias{nDronesColonyPhenotype}
\title{Sample a number of drones}
\usage{
nDronesPoisson(x, n = 1, average = 100)

nDronesTruncPoisson(x, n = 1, average = 100, lowerLimit = 0)

nDronesColonyPhenotype(
  x,
  queenTrait = 1,
  workersTrait = NULL,
  checkProduction = FALSE,
  lowerLimit = 0,
  ...
)
}
\arguments{
\item{x}{\code{\link{Pop-class}} or \code{\link{Colony-class}}}

\item{n}{integer, number of samples}

\item{average}{numeric, average number of drones}

\item{lowerLimit}{numeric, returned numbers will be above this value}

\item{queenTrait}{numeric (column position) or character (column name), trait
that represents queen's effect on the colony phenotype (defined in
\code{\link{SimParamBee}} - see examples); if \code{0} then this effect is 0}

\item{workersTrait}{numeric (column position) or character (column name), trait
that represents workers's effect on the colony phenotype (defined in
\code{\link{SimParamBee}} - see examples); if \code{0} then this effect is 0}

\item{checkProduction}{logical, does the phenotype depend on the production
status of colony; if yes and production is not \code{TRUE}, the result is
above \code{lowerLimit}}

\item{...}{other arguments of \code{\link{mapCasteToColonyPheno}}}
}
\value{
numeric, number of drones
}
\description{
Sample a number of drones - used when \code{nDrones = NULL}
  (see \code{\link{SimParamBee}$nDrones}).

  This is just an example. You can provide your own functions that satisfy
  your needs!
}
\details{
\code{nDronesPoisson} samples from a Poisson distribution with a
  given average, which can return a value 0.

  \code{nDronesTruncPoisson} samples from a zero truncated Poisson
  distribution.

  \code{nDronesColonyPhenotype} returns a number (above \code{lowerLimit}) as
  a function of colony phenotype, say queen's fecundity. Colony phenotype is
  provided by \code{\link{mapCasteToColonyPheno}}. You need to set up
  traits influencing the colony phenotype and their parameters (mean and
  variances) via \code{\link{SimParamBee}} (see examples).

  When \code{x} is \code{\link{Pop-class}}, only \code{workersTrait} is not
  used, that is, only \code{queenTrait} is used.
}
\section{Functions}{
\itemize{
\item \code{nDronesTruncPoisson()}: Sample a non-zero number of drones

\item \code{nDronesColonyPhenotype()}: Sample a non-zero number of drones based on
colony phenotype, say queen's fecundity

}}
\examples{
nDronesPoisson()
nDronesPoisson()
n <- nDronesPoisson(n = 1000)
hist(n, breaks = seq(from = min(n), to = max(n)), xlim = c(0, 200))
table(n)

nDronesTruncPoisson()
nDronesTruncPoisson()
n <- nDronesTruncPoisson(n = 1000)
hist(n, breaks = seq(from = min(n), to = max(n)), xlim = c(0, 200))
table(n)

# Example for nDronesColonyPhenotype()
founderGenomes <- quickHaplo(nInd = 3, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
average <- 100
h2 <- 0.1
SP$addTraitA(nQtlPerChr = 100, mean = average, var = average * h2)
SP$setVarE(varE = average * (1 - h2))
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(x = basePop[1], nInd = 50)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 2, nDrones = 15)
colony1 <- createColony(x = basePop[2])
colony2 <- createColony(x = basePop[3])
colony1 <- cross(colony1, drones = droneGroups[[1]])
colony2 <- cross(colony2, drones = droneGroups[[2]])
colony1@queen@pheno
colony2@queen@pheno
createDrones(colony1, nInd = nDronesColonyPhenotype)
createDrones(colony2, nInd = nDronesColonyPhenotype)
}
\seealso{
\code{\link{SimParamBee}} field \code{nDrones} and
  \code{vignette(topic = "QuantitativeGenetics", package = "SIMplyBee")}
}
