% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sipd_deps.R
\name{sipd_deps}
\alias{sipd_deps}
\title{Indicate dependecies of the packages inside SIPDIBGE}
\usage{
sipd_deps(survey = NULL)
}
\arguments{
\item{survey}{Name of the household survey for reference package information. If \code{NULL}, presents the information of all the packages inside this collection.}
}
\value{
A vector with packages in dependencies list of the packages inside SIPDIBGE.
}
\description{
This function describes packages in dependencies list of the packages inside SIPDIBGE.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/}> and consult the other functions of this package, described below.
}
\examples{
\donttest{
sipd_deps()
# Presenting information about the PNADcIBGE package
sipd_deps(survey="PNADC")
# Presenting information about the POFIBGE package
sipd_deps(survey="POF")
# Presenting information about the PNSIBGE package
sipd_deps(survey="PNS")
# Presenting information about the COVIDIBGE package
sipd_deps(survey="COVID")}
}
\seealso{
\link[SIPDIBGE]{sipd_conflicts} for indicating conflicts of the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_logo} for showing logos of the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_packages} for indicating the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_sitrep} for indicating version informations for the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_update} for indicating the existance of an update for the packages inside SIPDIBGE.
}
