% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_qSIP_MAGs.R
\name{qSIP_atom_excess_MAGs}
\alias{qSIP_atom_excess_MAGs}
\title{Calculate atom fraction excess using q-SIP method}
\usage{
qSIP_atom_excess_MAGs(
  physeq,
  control_expr,
  treatment_rep = NULL,
  isotope = "13C",
  df_OTU_W = NULL,
  Gi
)
}
\arguments{
\item{physeq}{A phyloseq object}

\item{control_expr}{Expression used to identify control samples based on sample_data.}

\item{treatment_rep}{Which column in the phyloseq sample data designates
replicate treatments}

\item{isotope}{The isotope for which the DNA is labeled with ('13C' or '18O')}

\item{df_OTU_W}{Keep NULL}

\item{Gi}{GC content of the MAG}
}
\value{
A list of 2 data.frame objects. 'W' contains the weighted mean buoyant density (W) values for each OTU in each treatment/control. 'A' contains the atom fraction excess values for each OTU. For the 'A' table, the 'Z' column is buoyant density shift, and the 'A' column is atom fraction excess.
}
\description{
Calculate atom fraction excess using q-SIP method
}
\examples{
data(phylo.qSIP,GC_content)
### Making atomx table
\donttest{
## Not run::
### BD shift (Z) & atom excess (A)
atomX = qSIP_atom_excess_MAGs(phylo.qSIP,
                         control_expr='Isotope=="12C"',
                         treatment_rep='Replicate',
                         Gi = GC_content)
}
}
