% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIRItoSP.R
\name{SIRItoSP}
\alias{SIRItoSP}
\title{Projects a SIRI data frame to a spatial points data frame}
\usage{
SIRItoSP(SIRIdf, epsg)
}
\arguments{
\item{SIRIdf}{the data frame to project}

\item{epsg}{a coordinate reference system code (can be extracted using \code{\link[rgdal]{make_EPSG}} and searching the table).}
}
\value{
A \code{\link[sp]{SpatialPointsDataFrame}} with SIRI's real-time data
}
\description{
Projects a subset of the SIRI data frame to a \code{\link[sp]{SpatialPointsDataFrame}} with the selected projection.
}
\details{
Requires the product of \code{\link{organizeSIRIdf}},
is interchangeable with \link[SIRItoGTFS]{SIRItoILTM}.
the function is a part of STG and should not be used on it's own.
}
\section{Warning}{

Do Not use this function on it's own, it is meant to be used only as part of the STG process
}

\references{
Bogin, D., Levy, N. and Ben-Elia E. (2018) \emph{Estimation of public transport service reliability using Big Data and open source tools}
}
\seealso{
\code{\link{STG}}, \code{\link{SIRItoILTM}}, \code{\link[sp]{SpatialPointsDataFrame}}, \code{\link{organizeSIRIdf}}
}
\keyword{internal}
\keyword{misc}
\keyword{spatial}
