% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizeSIRIdf.R
\name{organizeSIRIdf}
\alias{organizeSIRIdf}
\title{Organize the subset of the SIRI DataFrame}
\usage{
organizeSIRIdf(SIRIdf, noduplicates = FALSE, round = FALSE, GTFStrips.,
  GTFScalendar., GTFSstop_times.)
}
\arguments{
\item{SIRIdf}{A SIRI \code{\link[base]{data.frame}}}

\item{noduplicates}{logical, default is FALSE}

\item{round}{logical, should POSIXct column be rounded to nearest minute. default is FALSE.}

\item{GTFStrips.}{The GTFS trips table to be used}

\item{GTFScalendar.}{The GTFS calendar table to be used}

\item{GTFSstop_times.}{The GTFS stop_times table to be used}
}
\description{
Requires the product of \code{\link{SubsetSIRI}}.
Prepares the subset of the SIRI data for comparison with the GTFS tables.
}
\details{
Prepares the subset of the SIRI data.frame for comparison to the GTFS schedule
the function is a part of STG and should not be used on it's own.
}
\section{Warning}{

Do Not use this function on it's own, it is meant to be used only as part of the STG process
}

\references{
Bogin, D., Levy, N. and Ben-Elia E. (2018) \emph{Estimation of public transport service reliability using Big Data and open source tools}
}
\seealso{
\code{\link[SIRItoGTFS]{STG}}
}
\keyword{internal}
\keyword{misc}
