% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/substoptimes.R
\name{substoptimes}
\alias{substoptimes}
\title{Subset the stop_times table}
\usage{
substoptimes(SIRIdf, GTFSstop_times., GTFSroutes., GTFStrips., GTFScalendar.)
}
\arguments{
\item{SIRIdf}{A SIRI data.frame to use as reference}

\item{GTFSstop_times.}{The Stop times table from the GTFS, default name is GTFSstop_times}

\item{GTFSroutes.}{The Routes table from the GTFS, default name is GTFSroutes}

\item{GTFStrips.}{The trips table from the GTFS, default name is GTFStrips}

\item{GTFScalendar.}{The Calendar table from the GTFS, default name is TFScalendar}
}
\value{
A \code{\link[base]{data.frame}} with the exact same columns as the GTFSstop_times table, with only the rows relevant to the SIRI data present
}
\description{
Creates a simple subset of the GTFS to reference the SIRI data frame
}
\details{
creates a smaller subset of the GTFS stop_times table to use in further analysis of the SIRI data.
the function is a part of STG and should not be used on it's own.
}
\section{Warning}{

Do Not use this function on it's own, it is meant to be used only as part of the STG process
}

\references{
Bogin, D., Levy, N. and Ben-Elia E. (2018) \emph{Estimation of public transport service reliability using Big Data and open source tools}
}
\seealso{
\code{\link{STG}}
}
\keyword{internal}
\keyword{misc}
