% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDiagnostics.R
\name{plotDiagnostics}
\alias{plotDiagnostics}
\title{Plot results from diagnostics collected during model fitting}
\usage{
plotDiagnostics(
  object,
  ind = max(object$diagnostics$penalty),
  xvar = c("time", "iteration"),
  yvar,
  ...
)
}
\arguments{
\item{object}{an object of class \code{"SLOPE"}.}

\item{ind}{either "last"}

\item{xvar}{what to place on the x axis. \code{iteration} plots each iteration,
\code{time} plots the wall-clock time.}

\item{yvar}{deprecated (and ignored)}

\item{...}{other arguments that will be used to modify the call to
\code{\link[lattice:xyplot]{lattice::xyplot()}}}
}
\value{
An object of class \code{"trellis"}, which, unless stored in a variable,
will be plotted when its default \code{print()} method is called.
}
\description{
This function plots various diagnostics collected during
the model fitting resulting from a call to \code{\link[=SLOPE]{SLOPE()}} \emph{provided that
\code{diagnostics = TRUE}}.
}
\examples{
x <- SLOPE(abalone$x, abalone$y, alpha = 2, diagnostics = TRUE)
plotDiagnostics(x)
}
\seealso{
\code{\link[=SLOPE]{SLOPE()}}
}
