% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.smle}
\alias{summary.smle}
\alias{summary.selection}
\title{Summary of an object from class \code{'smle'} or \code{'selection'}}
\usage{
\method{summary}{smle}(object, ...)

\method{summary}{selection}(object, ...)
}
\arguments{
\item{object}{Fitted \code{'smle'} or \code{'selection'} object.}

\item{...}{This argument is not used and listed for method consistency.}
}
\value{
No return value.
}
\description{
This function prints a summary of a \code{'smle'} (or a \code{'selection'}) object.
In particular, it shows the features retained after SMLE-screening (or selection) with the related convergence information.
}
\examples{
set.seed(1)
Data<-Gen_Data(correlation="MA",family = "gaussian")
fit<-SMLE(Data$Y,Data$X,k=20,family = "gaussian")
summary(fit)
fit_s <- smle_select(fit)
summary(fit_s)

}
