% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNP.eq.R
\name{BNP.eq}
\alias{BNP.eq}
\title{Bayesian non-parametric model for test equating}
\usage{
BNP.eq(scores_x, scores_y, range_scores = NULL, design = "EG",
  covariates = NULL, prior = NULL, mcmc = NULL, normalize = TRUE)
}
\arguments{
\item{scores_x}{Vector.  Scores of form X.}

\item{scores_y}{Vector.  Scores of form Y.}

\item{range_scores}{Vector of length 2.  Represent the minimum and maximum scores in the test.}

\item{design}{Character.  Only supports 'EG' design now.}

\item{covariates}{Data.frame.  A data frame with factors, containing covariates 
for test X and Y, stacked in that order.}

\item{prior}{List.  Prior information for BNP model. 
For more information see DPpackage.}

\item{mcmc}{List.  MCMC information for BNP model. 
For more information see DPpackage.}

\item{normalize}{Logical.  Whether normalize or not the 
response variable. This is due to Berstein's polynomials. Default is TRUE.}
}
\value{
A 'BNP.eq' object, which is list containing the following items:

Y Response variable.

X Design Matrix.

fit DPpackage object. Fitted model with raw samples.

max_score Maximum score of test.

patterns A matrix describing the different patterns formed
        from the factors in the covariables.

patterns_freq The normalized frequency of each pattern.
}
\description{This function implements the Bayesian nonparametric approach for test equating 
as described in Gonzalez, Barrientos and Quintana (2015) <\doi{https://doi.org/10.1016/j.csda.2015.03.012}>. 
The main idea consists of introducing covariate dependent Bayesian nonparametric models for a collection of 
covariate-dependent equating transformations

 \eqn{ \left\{ \boldsymbol{\varphi}_{\boldsymbol{z}_f, \boldsymbol{z}_t} (\cdot): 
           \boldsymbol{z}_f, \boldsymbol{z}_t \in \mathcal{L}
       \right\} 
  }
}
\details{
The Bayesian nonparametric (BNP) approach starts by focusing on spaces of distribution 
functions, so that uncertainty is expressed on F itself. The prior distribution p(F) is 
defined on the space F of all distribution functions defined on X . If X is an infinite 
set then F is infinite-dimensional, and the corresponding prior model p(F) on F is termed 
nonparametric. The prior probability model is also referred to as a random probability 
measure (RPM), and it essentially corresponds to a distribution on the space of all 
distributions on the set X . Thus Bayesian nonparametric models are probability models 
defined on a function space.
}
\author{
Daniel Leon \email{dnacuna@uc.cl}, Felipe Barrientos \email{afb26@stat.duke.edu}.
}
\references{
Gonzalez, J., Barrientos, A., and Quintana, F. (2015). Bayesian Nonparametric Estimation of Test Equating Functions with Covariates. \emph{Computational Statistics and Data Analysis, 89,} 222-244. 
}
\keyword{nonparametric}
\concept{Bayesian}
\concept{equating}



