% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/spotEnsembleFunctions.R
\name{spotFeedback}
\alias{spotFeedback}
\alias{spotFeedback.deviation}
\alias{spotFeedback.error.combo}
\alias{spotFeedback.error.full}
\alias{spotFeedback.error.last}
\alias{spotFeedback.error.order}
\alias{spotFeedback.reward.bern}
\alias{spotFeedback.reward.norm}
\alias{spotFeedback.sd.interSubModelsFull}
\alias{spotFeedback.y}
\title{Ensemble Feedback Functions}
\usage{
spotFeedback.y(spotConfig,mergedB,rawB)
spotFeedback.sd.interSubModelsFull(spotConfig,mergedB,rawB)
spotFeedback.deviation(spotConfig,mergedB,rawB)
spotFeedback.error.full(spotConfig,mergedB,rawB)
spotFeedback.error.last(spotConfig,mergedB,rawB)
spotFeedback.error.order(spotConfig,mergedB,rawB)
spotFeedback.error.combo(spotConfig,mergedB,rawB)
spotFeedback.reward.bern(spotConfig,mergedB,rawB)
spotFeedback.reward.norm(spotConfig,mergedB,rawB)
}
\arguments{
\item{spotConfig}{parameter list, as created by the calling functions}

\item{mergedB}{merged list of design points as evaluated on the target function of SPOT}

\item{rawB}{raw list of design points as evaluated on the target function of SPOT}
}
\value{
\code{spotFeedback.y, spotFeedback.sd.interSubModelsFull and spotFeedback.deviation} return a matrix with as many columns as models in the ensemble and as many rows as points in mergedB. \cr
 \code{spotFeedback.reward.bern and spotFeedback.reward.norm} return single values, which indicate the Bernoulli or normal distributed reward for the model used in the last sequential step. \cr
all other functions return a vector with an error measure for each model in the ensemble.
}
\description{
This describes the feedback functions which can be employed in the \code{spotEnsembleSingle*} and \code{spotEnsembleMulti*} functions.
}
\details{
If \code{spotFeedback.error.full} or \code{spotFeedback.error.last} are used, the user can choose an error function of type \code{f(a,b)} where \code{a}
and \code{b} are vectors whose differences are the deviations between model and real function. By default this function is chosen with
\code{spotConfig$seq.ensemble.error.func <- spotSelectionRmse}. See \code{\link{spotSelectionCriteria}} for some other options.
Note that ".full" indicates that the modelling error is calculated based on all known design points, whereas ".last" indicates that the modelling error is only calculated based
on the last evaluated design points, which can be considered unseen data for the model. Therefore, ".full" might be biased, whereas ".last" might be more random due to the small
number of samples. \code{spotFeedback.error.full} and \code{spotFeedback.error.last} return scalar values for each model, i.e. a vector.\cr\cr
\code{spotFeedback.y} simply returns predictions from previous steps. It therefore returns a vector for each model, i.e. a matrix of num-model columns, and npoints rows.\cr\cr
\code{spotFeedback.sd.interSubModelsFull} when cut off sub-designs are available for validation, this function can be used to calculate the standard deviation at each point. It therefore returns a vector for each model, i.e. a matrix of num-model columns, and npoints rows.\cr\cr
\code{spotFeedback.reward*} reward based on success of the model used in last sequential step. Scalar value returned.
}

