% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handleNAs.R
\name{imputeY}
\alias{imputeY}
\title{Impute NAs and Inf in y}
\usage{
imputeY(x, y, control)
}
\arguments{
\item{x}{The x values from which y was calculated}

\item{y}{The vector of numerics from which NA/Inf values should be removed}

\item{control}{\code{\link{spot}} control list. See also \code{\link{spotControl}}.}
}
\value{
y The imputed vector w/o \code{NA} and w/o \code{Inf} values.
}
\description{
Impute NAs and Inf in y
}
\examples{

x <- matrix(runif(10), ncol=2, nrow=5)
y <- funSphere(x)
y[1] <- NA
control <- spotControl(dimension = 2)
# no imputation function, i.e, w/o imputation
imputeY(x=x, y=y, control=control)
# with imputation
control$yImputation$handleNAsMethod <- handleNAsKrigingWorst
y <- imputeY(x=x, y=y, control=control)
# no imputation required:
imputeY(x=x, y=y, control=control)

}
