% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funContinuous.R
\name{funBox3d}
\alias{funBox3d}
\title{funbox3D (No. 18, More No. 12)}
\usage{
funBox3d(x)
}
\arguments{
\item{x}{matrix of points to evaluate with the function.
Rows for points and columns for dimension.}
}
\value{
1-column matrix with resulting function values
}
\description{
Box three-dimensional Test Function
}
\references{
More, J. J., Garbow, B. S., and  Hillstrom, K. E. (1981).
Testing unconstrained optimization software.
\emph{ACM Transactions on Mathematical Software (TOMS)}, \emph{7}(1), 17-41.
\doi{10.1145/355934.355936}

Box three - dimensional, (1966).
A comparison of several current optimization methods, and the use of transformations
 in constrained problems.
\emph{The Computer Journal}, \emph{3}(3), 66-77.
\url{https://academic.oup.com/comjnl/article/9/1/67/348150}

 @examples
x <- matrix(c(1,10,1),1,)
funBox3d(x)

res <- spot(,funBox3d,c(5,15,-5),c(15,5,5),control=list(funEvals=20))
# plotting the graphs
plotModel(res$model,which=1:2)
plotModel(res$model,which=2:3)
plotModel(res$model,which=c(1,3))
}
