% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotPlot.R
\name{plot_parallel}
\alias{plot_parallel}
\title{Parallel coordinate plot of a data set}
\usage{
plot_parallel(
  object,
  yrange = NULL,
  yvar = 1,
  xlab = paste("x", 1:ncol(x), sep = ""),
  ylab = "y",
  ...
)
}
\arguments{
\item{object}{the result list returned by \code{\link[SPOT]{spot}}, importantly including a \code{modelFit}, and the data \code{x}, \code{y}.}

\item{yrange}{a two-element vector that specifies the range of y values to consider (data outside of that range will be excluded).}

\item{yvar}{integer which specifies the variable that is displayed on the color scale. yvar==1 (default) means that the y-variable is shown (tuned measure). Larger integers mean that respective columns from logInfo are used (i.e., yvar specifies the respective column number, starting with 2 for the first logged value).}

\item{xlab}{a vector of characters, giving the labels for each of the two independent variables.}

\item{ylab}{character, the value of the dependent variable predicted by the corresponding model.}

\item{...}{additional parameters (currently unused).}
}
\value{
plotly parallel coordinate plot ('parcoords') visualization (based on \code{\link[plotly]{plot_ly}})
}
\description{
mlrTools
}
\seealso{
\code{\link[SPOT]{plotFunction}}, \code{\link[SPOT]{plotData}}
}
