% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funKerasCensus.R
\name{predMlCensus}
\alias{predMlCensus}
\title{Predict machine learning models on Census data}
\usage{
predMlCensus(
  x = NULL,
  model = NULL,
  target = "age",
  task.type = "classif",
  nobs = 10000,
  nfactors = "high",
  nnumericals = "high",
  cardinality = "high",
  cachedir = "oml.cache",
  k = 1,
  prop = 2/3,
  verbosity = 0
)
}
\arguments{
\item{x}{matrix hyperparameter, e.g., result from \code{\link[SPOT]{spot}}
Load result data for ml model to get the hyperparamater vector x, e.g.,
\code{load("data/resdl11.RData")} and
\code{x <- result$xbest} or use default.}

\item{model}{character ml model, e.g., \code{"kknn"}
run: \code{result$xbest}. If \code{NULL}, default parameters will be used.
Default: \code{NULL}.}

\item{target}{target}

\item{task.type}{class/reg}

\item{nobs}{number of obsvervations, max: 229,285}

\item{nfactors}{(character) number of factor variables}

\item{nnumericals}{(character) number of numerical variables}

\item{cardinality}{(character) cardinality}

\item{cachedir}{cachedir}

\item{k}{number of repeats}

\item{prop}{split proportion. Default: \code{c(3/5,1)}.}

\item{verbosity}{verbsity. Default: 0}
}
\value{
list of matrices with predictions and true values
}
\description{
Predict machine learning models on Census data
}
