% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msi.dataset_methods.R
\docType{methods}
\name{getMZ,msi.dataset-method}
\alias{getMZ,msi.dataset-method}
\alias{getMZ}
\title{Return the m/z vector.}
\usage{
\S4method{getMZ}{msi.dataset}(object)
}
\arguments{
\item{object}{\link{msi.dataset-class} object.}
}
\value{
vector containing the m/z values.
}
\description{
Return the m/z vector.
}
\examples{
## Load package
library("SPUTNIK")

## Create the msi.dataset-class object
sz <- c(5, 4)
x <- matrix(rnorm(sz[1] * sz[2] * 20), sz[1]*sz[2], 20)
mz <- sort(sample(100, ncol(x)))
msiX <- msiDataset(x, mz, sz[1], sz[2])

## Get m/z vector
mz <- getMZ(msiX)

## Get intensity matrix
X <- getIntensityMat(msiX)

## Get image size
sz <- getShapeMSI(msiX)
}
