% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_gene.R
\name{visualize_gene}
\alias{visualize_gene}
\title{Visualize expression pattern for the gene of interest in reference data and synthetic data}
\usage{
visualize_gene(
  simsrt,
  plotgn = NULL,
  ptsizeCount = 2,
  textsizeCount = 12,
  rev_y = FALSE,
  virOption = "D",
  virDirection = -1
)
}
\arguments{
\item{simsrt}{A SRTsim object}

\item{plotgn}{A gene name selected for visualization}

\item{ptsizeCount}{Specification of point size. Default is 2.}

\item{textsizeCount}{Specification of axis font size. Default is 12.}

\item{rev_y}{Logical indicating whether to reverse the y axis. Default is FALSE. Useful for Visualize the LIBD data.}

\item{virOption}{Specification of \code{option} in the \code{scale_color_viridis}. Default is "D". User can choose a letter from 'A' to 'H'.}

\item{virDirection}{Specification of \code{direction} in the \code{scale_color_viridis}. Default is "-1".  User can choose '1' or '-1'.}
}
\value{
Returns two expression plots for the gene of interest
}
\description{
Visualize expression pattern for the gene of interest in reference data and synthetic data
}
\examples{

## Create a simSRT object
toySRT  <- createSRT(count_in=toyData$toyCount,loc_in = toyData$toyInfo)
set.seed(1)
## Create New Locations within Profile
toySRT2 <- srtsim_newlocs(toySRT,new_loc_num=1000)

## Estimate model parameters for data generation
toySRT2 <- srtsim_fit(toySRT2,sim_schem="tissue")

## Generate synthetic data with estimated parameters
toySRT2     <- srtsim_count(toySRT2,rrr=1)

## compare the expression pattern of HLA-B in synthetic data and reference data
visualize_gene(simsrt=toySRT2,plotgn = "HLA-B")
}
