% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{srt.style}
\alias{srt.style}
\title{Change Style of Subtitle}
\usage{
srt.style(srt, line = "all", pos = "None", style = "None",
  col = "None")
}
\arguments{
\item{srt}{vector. The srt file read by \code{\link[SRTtools]{srt.read}}.}

\item{line}{numerical vector. Style will only change the subtitles of the selected subtitle index, default is 'all', means the whole subtitles will apply the style.}

\item{pos}{character. The subtitles position, the valid options are '\code{bottom-left}', '\code{bottom-center}', '\code{bottom-right}', '\code{middle-left}', '\code{middle-center}', '\code{middle-right}', '\code{top-left}', '\code{top-center}', '\code{top-right}' and '\code{center}'.}

\item{style}{character vector. The styles that subtitle applied, '\code{u}' for bottom line, '\code{i}' for italic, '\code{b}' for bold, '\code{s}' for strikethrough.}

\item{col}{character. The color that subtitle applied.}
}
\description{
Change subtitle style or posistion by specific subtitle index.
}
\examples{
srt_path <- system.file("extdata", "movie.srt", package="SRTtools")
srt <- srt.read(srt_path, encoding = 'utf-8')
srt.style(srt, line = c(1,3,5), pos = 'top-left', style = c('b','i'), col = 'red')

}
\seealso{
\code{\link[SRTtools]{srt.read}}
}
