% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_utils.R
\name{formula_include_hierarchies}
\alias{formula_include_hierarchies}
\title{Replace variables in formula with sum of other variables}
\usage{
formula_include_hierarchies(
  f,
  hier_vars,
  simplify = TRUE,
  env = parent.frame()
)
}
\arguments{
\item{f}{model formula}

\item{hier_vars}{named list. the names of \code{hier_vars} must correspond to variables in \code{f}.
Each element in \code{hier_vars} must be a character vector consisting of those
variables you wish to replace}

\item{simplify}{logical value, default TRUE. Determines whether the formula
should be simplified before output or not.}

\item{env}{the environment for the output formula}
}
\value{
model formula
}
\description{
Replace variables in formula with sum of other variables
}
\examples{
f2 <- formula_from_vars(c("a", "b", "c"), c("a", "c"))
formula_include_hierarchies(f2, list(a = c("hello", "world")),
simplify = FALSE)
}
\author{
Daniel Lupp
}
\keyword{internal}
