% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_var.R
\name{load_var}
\alias{load_var}
\title{Load environmental variables}
\usage{
load_var(path = getwd(), files = NULL, format = c(".grd", ".tif", ".asc",
  ".sdat", ".rst", ".nc", ".envi", ".bil", ".img"), categorical = NULL,
  Norm = TRUE, tmp = TRUE, verbose = TRUE, GUI = FALSE)
}
\arguments{
\item{path}{character. Path to the directory that contains the environmental variables
files.}

\item{files}{character. Files containing the environmental variables If NULL
(default) all files present in the path in the selected format will
be loaded.}

\item{format}{character. Format of environmental variables files
(including .grd, .tif, .asc, .sdat, .rst, .nc, .tif, .envi, .bil, .img).}

\item{categorical}{character. Specify whether an environmental variable is a categorical variable.}

\item{Norm}{logical. If set to true, normalizes environmental variables between 0 and 1.}

\item{tmp}{logical. If set to true, rasters are
read in temporary file avoiding to overload the random access memory. But
beware: if you close R, temporary files will be deleted.}

\item{verbose}{logical. If set to true, allows the function to print text in the
console.}

\item{GUI}{logical. Do not take that argument into account (parameter for the
user interface).}
}
\value{
A stack containing the environmental rasters (normalized or
 not).
}
\description{
Function to load environmental variables in the form of rasters to perform
\code{\link{modelling}}, \code{\link{ensemble_modelling}} or
\code{\link{stack_modelling}}.
}
\examples{
\dontrun{
load_var(system.file('extdata',  package = 'SSDM'))
}

}
\seealso{
\code{\link{load_occ}} to load occurrences.
}
