% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.model.R
\docType{methods}
\name{save.model}
\alias{save.model}
\alias{save.esdm}
\alias{save.esdm,Ensemble.SDM-method}
\alias{save.stack}
\alias{save.stack,Stacked.SDM-method}
\title{Save ensemble SDMs and SSDMs}
\usage{
save.esdm(esdm, name = strsplit(esdm@name, ".", fixed = TRUE)[[1]][1],
  path = getwd(), verbose = TRUE, GUI = FALSE)

\S4method{save.esdm}{Ensemble.SDM}(esdm, name = strsplit(esdm@name,
  ".Ensemble.SDM", fixed = TRUE)[[1]][1], path = getwd(),
  verbose = TRUE, GUI = FALSE)

save.stack(stack, name = "Stack", path = getwd(), verbose = TRUE,
  GUI = FALSE)

\S4method{save.stack}{Stacked.SDM}(stack, name = "Stack",
  path = getwd(), verbose = TRUE, GUI = FALSE)
}
\arguments{
\item{esdm}{Ensemble.SDM. Ensemble SDM to be saved.}

\item{name}{character. Folder name of the model to save.}

\item{path}{character. Path to the directory chosen to save the SDM,
by default the path to the current directory.}

\item{verbose}{logical. If set to true, allows the function to print text in the
console.}

\item{GUI}{logical. Don't take that argument into account (parameter for the
user interface).}

\item{stack}{Stacked.SDM. SSDM to be saved.}
}
\value{
Nothing in R environment. Creates folders, tables and rasters
  associated to the SDM. Tables are in .csv and rasters in .grd/.gri.
}
\description{
Allows to save S4 \linkS4class{Ensemble.SDM} and \linkS4class{Stacked.SDM}
class objects.
}
\seealso{
\code{\link{load.model}}
}
