% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomForest.R
\name{SSLRRandomForest}
\alias{SSLRRandomForest}
\title{General Interface Random Forest model}
\usage{
SSLRRandomForest(
  mtry = NULL,
  trees = 500,
  min_n = NULL,
  w = 0.5,
  replace = TRUE,
  tree_max_depth = Inf,
  sampsize = NULL,
  min_samples_leaf = NULL,
  allowParallel = TRUE
)
}
\arguments{
\item{mtry}{number of features in each decision tree.
Default is null. This means that mtry = log(n_features) + 1}

\item{trees}{number of trees. Default is 500}

\item{min_n}{number of minimum samples in each tree
Default is null. This means that uses all training data}

\item{w}{weight parameter ranging from 0 to 1. Default is 0.5}

\item{replace}{replacing type in sampling. Default is true}

\item{tree_max_depth}{maximum tree depth. Default is Inf}

\item{sampsize}{Size of sample. Default if (replace) nrow(x) else ceiling(.632*nrow(x))}

\item{min_samples_leaf}{the minimum number of any terminal leaf node. Default is 1}

\item{allowParallel}{Execute Random Forest in parallel if doParallel is loaded.
Default is TRUE}
}
\description{
Random Forest is a simple and effective semi-supervised
learning method. It is the same as the traditional Random Forest
algorithm, but the difference is that it use Semi supervised Decision Trees
It can be used in classification or regression. If Y is numeric is for regression, classification in another case
}
\details{
We can use paralleling processing with doParallel package and allowParallel = TRUE.
}
\examples{
library(tidyverse)
library(caret)
library(SSLR)
library(tidymodels)

data(wine)

set.seed(1)
train.index <- createDataPartition(wine$Wine, p = .7, list = FALSE)
train <- wine[ train.index,]
test  <- wine[-train.index,]

cls <- which(colnames(wine) == "Wine")

#\% LABELED
labeled.index <- createDataPartition(train$Wine, p = .2, list = FALSE)
train[-labeled.index,cls] <- NA


m <- SSLRRandomForest(trees = 5,  w = 0.3) \%>\% fit(Wine ~ ., data = train)

#Accuracy
predict(m,test) \%>\%
  bind_cols(test) \%>\%
  metrics(truth = "Wine", estimate = .pred_class)


#For probabilities
predict(m,test, type = "prob")

}
\references{
Jurica Levati, Michelangelo Ceci, Dragi Kocev, Saso Dzeroski.\cr
\emph{Semi-supervised classification trees.}\cr
Published online: 25 March 2017
© Springer Science Business Media New York 2017
}
