% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_func.R
\name{dist_wei_mat_preds}
\alias{dist_wei_mat_preds}
\title{Creates a list of distances and weights between observed and prediction sites}
\usage{
dist_wei_mat_preds(path = path, net = 1, addfunccol = "addfunccol")
}
\arguments{
\item{path}{Path with the name of the SSN object}

\item{net}{(optional) A network from the SSN object}

\item{addfunccol}{(optional) A parameter to compute the spatial weights}
}
\value{
A list of matrices
}
\description{
The output matrices are symmetric except the hydrologic distance matrix D.
}
\examples{
\donttest{
path <- system.file("extdata/clearwater.ssn", package = "SSNbayes")
mat_all_pred <- dist_wei_mat_preds(path, net = 2, addfunccol='afvArea')}
}
