% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReceptorGeneSetConstruction.R
\name{receptorGeneSetConstruction}
\alias{receptorGeneSetConstruction}
\title{Gene sets weights membership matrix construction for receptor abundance estimation.}
\usage{
receptorGeneSetConstruction(
  train.rnaseq,
  train.citeseq,
  rank.range.end = 100,
  min.consec.diff = 0.01,
  rep.consec.diff = 2,
  manual.rank = NULL,
  seed.rsvd = 1
)
}
\arguments{
\item{train.rnaseq}{\eqn{m x n} scRNA-seq counts matrix for \eqn{m} cells
and \eqn{n} genes.}

\item{train.citeseq}{\eqn{m x h} CITE-seq ADT counts matrix for \eqn{m} cells (same cells as the \code{train.rnaseq matrix}) and \eqn{h} cell-surface proteins.}

\item{rank.range.end}{See documentation for the \code{randomizedRRR} function from the \code{SPECK} package.}

\item{min.consec.diff}{See documentation for the \code{randomizedRRR} function from the \code{SPECK} package.}

\item{rep.consec.diff}{See documentation for the \code{randomizedRRR} function from the \code{SPECK} package.}

\item{manual.rank}{See documentation for the \code{randomizedRRR} function from the \code{SPECK} package.}

\item{seed.rsvd}{See documentation for the \code{randomizedRRR} function from the \code{SPECK} package.}
}
\value{
\itemize{
  \item \code{receptor.geneset.matrix} - A \eqn{n x h} gene sets weights membership matrix where a column \eqn{i} from \eqn{h} corresponds to the weights for \eqn{n} genes from the scRNA-seq matrix trained against the corresponding CITE-seq ADT transcript \eqn{h}.
}
}
\description{
Computes \eqn{n x h} gene sets weights membership matrix using associations learned between log-normalized and reduced rank reconstructed (RRR)
\eqn{m x n} scRNA-seq training data and \eqn{m x h} CITE-seq ADT training counts normalized using the centered log ratio (CLR) transformation. scRNA-seq counts are normalized and
RRR using the \code{\link[SPECK:randomizedRRR]{SPECK::randomizedRRR()}} function while CITE-seq counts are normalized using the
\code{\link[Seurat:NormalizeData]{Seurat::NormalizeData()}} function with the \code{normalization.method} parameter set to \code{CLR}. Spearman rank correlations are computed between the
normalized CITE-seq data and the normalized and RRR scRNA-seq data.
}
\examples{
data("train.malt.rna.mat")
data("train.malt.adt.mat")
receptor.geneset.matrix.out <- receptorGeneSetConstruction(train.rnaseq =
                                         train.malt.rna.mat[1:100,1:80],
                                         train.citeseq =
                                         train.malt.adt.mat[1:100,1:2],
                                         rank.range.end = 70,
                                         min.consec.diff = 0.01,
                                         rep.consec.diff = 2,
                                         manual.rank = NULL, seed.rsvd = 1)
dim(receptor.geneset.matrix.out)
head(receptor.geneset.matrix.out)
}
