#' US County Map
#'
#' US County boundaries from the US Census Bureau's MAF/TIGER geographic database. Reprojected using Albers Equal Area.
#'
#' @format A \code{\link[sp]{SpatialPolygonsDataFrame}} object
#'
#' @references United States Census Bureau. Data accessed from the US Census Bureau website: http://www2.census.gov/geo/tiger/GENZ2010/gz_2010_us_050_00_20m.zip; accessed 06 April 2018
#'
#' @docType data
#' @keywords datasets
#' @name us_aea
#' @usage data(us_aea)
#' @source \href{https://www.census.gov/geo/maps-data/data/cbf/cbf_counties.html}{US Census Bureau}
#'

"us_aea"
