% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssc_meancomp.R
\name{ssc_meancomp}
\alias{ssc_meancomp}
\title{Sample Size Calculation for the Comparison of Means in Phase III Clinical Trials}
\usage{
ssc_meancomp(design = c(1,2,3,4), ratio, alpha, power, sigma, theta, delta)
}
\arguments{
\item{design}{The design of the clinical trials.
\cr 1
  \cr Testing for equality
\cr 2
  \cr Superiority trial
\cr 3
  \cr Non-inferiority trial
\cr 4
  \cr Equivalence trial.}

\item{ratio}{The ratio between the number of subjects in the treatment arm and that in the control arm.}

\item{alpha}{Type I error rate}

\item{power}{Statistical power of the test (1-type II error rate)}

\item{sigma}{The variance of observed outcomes in both arms}

\item{theta}{The difference between means in the two arms}

\item{delta}{The prespecified non-inferiority or equivalence margin in non-inferiority (3) or equivalence (4) trials}
}
\value{
samplesize
}
\description{
This function aims to calculate sample size for the comparison of means
in Phase III clinical trials.
}
\examples{
##The comparison of means, a non-inferiority trial with a non-inferiority margin 0.5
##the true treatment difference is assumed to be zero in non-inferiority and equivalence trials
ssc_meancomp(design=3, ratio=1, alpha=0.05, power=0.9, sigma=1, theta=0, delta=0.5)

}
\references{
Yin, G. (2012). Clinical Trial Design: Bayesian and Frequentist Adaptive Methods. John Wiley & Sons.
}
