\name{adjustSize}
\Rdversion{1.2}
\alias{adjustSize}
\title{
Adjustment of the sample size in case it is externally given
}
\description{
The optimisation step finds the best stratification that minimises the sample size under given precision constraints.
In some cases, the goal is not the minimisation of the sample size, as this value is given externally. Nonetheless, it is
still possible to perform the optimisation of the stratification, and after that proceed to an adjustment of the sample size
by increasing or decreasing it proportionally in each resulting stratum.
}
\usage{
adjustSize(size, strata, cens=NULL)
}
\arguments{
  \item{size}{
The value of the sample size given externally
	}
  \item{strata}{
The new (aggregated) strata generated by the function 'optimizeStrata'
	}
  \item{cens}{
The strata to be censused
 	}
}
\value{
The strata generated by the function 'optimizeStrata', where the variable 'SOLUZ' has been adjusted by taking into account the total required sample size
}

\author{
Giulio Barcaroli
}

\examples{
\dontrun{
library(SamplingStrata)
data(swisserrors)
data(swissstrata)
solution <- optimizeStrata (
	errors = swisserrors,
	strata = swissstrata,
	cens = NULL,
	strcens = FALSE,
	alldomains = TRUE,
	dom = dominio,
	initialStrata = nrow(swissstrata)/3,
	addStrataFactor = 0.01,
	minnumstr = 2,
	iter = 50,
	pops = 20,
	mut_chance = 0.05,
	elitism_rate = 0.2,
	highvalue = 100000000,
	suggestions = NULL,
	realAllocation = TRUE,
	writeFiles = FALSE)
# 
sum(solution$aggr_strata$SOLUZ)
# Adjustment of total sample size (decreasing)
adjustedStrata <- adjustSize(size=300,strata=solution$aggr_strata,cens=NULL)
sum(adjustedStrata$SOLUZ)
# Adjustment of total sample size (increasing)
adjustedStrata <- adjustSize(size=500,strata=solution$aggr_strata,cens=NULL)
sum(adjustedStrata$SOLUZ)
}
}

\keyword{ survey }