% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/allocation.R
\name{allocation}
\alias{allocation}
\title{Seat allocation and its ordering}
\usage{
allocation(parties, votes, seats, method, hurdle = 0)
}
\arguments{
\item{parties}{A vector containig the identification of parties or candidates accordingly to the election outcome.}

\item{votes}{A vector containing the total number of formal votes received by the parties/candidates.}

\item{seats}{A vector for the number of seats to be filled (the district magnitude).}

\item{method}{An integer for the method of allocation: method=2 Sainte-Lague; method=1 D'Hondt}

\item{hurdle}{The percentage of votes that must be reached to get seats in parliament.}
}
\description{
Compute seat allocation and its ordering for several values of seats and divisor methods with the same quotiens table.
}
\examples{
# Allocation example:
votes <- sample(1:10000, 5)
allocation(letters[1:5], votes, seats=8, method=1)
allocation(letters[1:5], votes, seats=c(3,5,8), method=2:1, hurdle=0.5)
}

