% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/error.bar.R
\encoding{UTF-8}
\name{error.bar}
\alias{error.bar}
\title{Add Error Bars on the Graph}
\usage{
error.bar(x, y, upper, lower = upper, length = 0.1, ...)
}
\arguments{
\item{x}{Coordinates for the error bars, or simply the name of the graph.}

\item{y}{Coordinates for the center of the error bars, which is the group means.}

\item{upper}{The length of the error bar, typically 1 \code{se} or \code{sd} in each direction.}

\item{lower}{The error bars.}

\item{length}{The length of the marks.}

\item{\dots}{typically additional noninteresting arguments to pass.}
}
\description{
Draws error bars.
}
\keyword{.1)}
\keyword{1.96*y.sd/10,}
\keyword{<-}
\keyword{=}
\keyword{Graphics}
\keyword{apply(y,2,mean)}
\keyword{apply(y,2,sd)}
\keyword{axis.lty=1)}
\keyword{barplot}
\keyword{barplot(y.means,}
\keyword{error.bar(barplot,y.means,}
\keyword{length}
\keyword{matrix(y,300,3)}
\keyword{mean=1)}
\keyword{names.arg=1:3,ylim=c(0,1.5),}
\keyword{rnorm(1000,}
\keyword{y}
\keyword{y.means}
\keyword{y.sd}

