% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source_sba.R
\name{contract_grid}
\alias{contract_grid}
\title{Grid contraction}
\usage{
contract_grid(z, Fz, lower, upper, add_back = TRUE, monotone = TRUE)
}
\arguments{
\item{z}{grid points (ordered)}

\item{Fz}{function evaluated at those grid points}

\item{lower}{lower threshold at which to check Fz}

\item{upper}{upper threshold at which to check Fz}

\item{add_back}{logical; if true, expand the grid to
(about) the original size}

\item{monotone}{logical; if true, enforce monotonicity
on the expanded grid}
}
\value{
a list containing the grid points \code{z} and the (interpolated) function
\code{Fz} at those points
}
\description{
Contract the grid if the evaluation points exceed some threshold.
This removes the corresponding z values.
We can add points back to achieve the same (approximate) length.
}
