% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoboost.R
\name{plot.summary.selectboost}
\alias{plot.summary.selectboost}
\title{Plot a summary of selectboost results}
\usage{
\method{plot}{summary.selectboost}(x, ...)
}
\arguments{
\item{x}{Numerical matrix. Summary of selectboost object.}

\item{...}{. Passed to the plotting functions.}
}
\value{
An invisible list.
}
\description{
Plot a summary of selectboost results.
}
\details{
\code{plot.summary.selectboost} returns an invisible list and creates four graphics.
Two plots the proportion of selection with respect to c0 (by step or according to real scale).
On the third graph, no bar means a proportion of selection less than prop.level.
Confidence intervals are computed at the conf.int.level level.
Barplot of the confidence index (1-min(c0, such that proportion|c0>conf.threshold)).
}
\examples{
data(autoboost.res.x)
plot(summary(autoboost.res.x))

data(autoboost.res.x2)
plot(summary(autoboost.res.x2))

}
\references{
\emph{selectBoost: a general algorithm to enhance the performance of variable selection methods in correlated datasets}, Frédéric Bertrand, Ismaïl Aouadi, Nicolas Jung, Raphael Carapito, Laurent Vallat, Seiamak Bahram, Myriam Maumy-Bertrand, Bioinformatics, 2020. \doi{10.1093/bioinformatics/btaa855}
}
\seealso{
\code{\link{fastboost}}, \code{\link{autoboost}} and \code{\link{summary.selectboost}}

Other Selectboost analyze functions: 
\code{\link{auto.analyze}()},
\code{\link{trajC0}()}
}
\author{
Frederic Bertrand, \email{frederic.bertrand@math.unistra.fr}
}
\concept{Selectboost analyze functions}
