% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.nets.R
\name{compare.nets}
\alias{compare.nets}
\title{Plots Two Networks for Comparison}
\usage{
compare.nets(A, B, titleA, titleB)
}
\arguments{
\item{A}{Character.
Matrix or data frame of network adjacency matrix}

\item{B}{Character.
Matrix or data frame of network adjacency matrix}

\item{titleA}{Character.
Title for network \code{A}}

\item{titleB}{Character.
Title for network \code{B}}
}
\value{
Plots two networks with multidimensional scaling layout
(see \code{\link[networktools]{MDSnet}} for more details)
}
\description{
Uses \code{\link[qgraph]{qgraph}} and \code{\link[networktools]{MDSnet}}
to plot networks in a layout that provides meaningful comparisons of distances
(see Jones, Mair, & McNally, 2018)
}
\examples{
# Simulate Datasets
one <- sim.fluency(10)
two <- sim.fluency(10)

# Compute similarity matrix
cos1 <- similarity(one, method = "cosine")
cos2 <- similarity(two, method = "cosine")

# Compute networks using NetworkToolbox
net1 <- NetworkToolbox::TMFG(cos1)$A
net2 <- NetworkToolbox::TMFG(cos2)$A

# Compare networks
compare.nets(net1, net2, "One", "Two")

}
\references{
Epskamp, S., Cramer, A. O. J., Waldorp, L. J., Schmittmann, V. D., & Borsboom, D. (2012).
qgraph: Network visualizations of relationships in psychometric data.
\emph{Journal of Statistical Software}, \emph{48}, 1-18.
Retrieved from: http://www.jstatsoft.org/v48/i04/

Jones, P. J. (2019).
networktools: Tools for Identifying Important Nodes in Networks.
R package version 1.2.1.
\href{https://CRAN.R-project.org/package=networktools}{https://CRAN.R-project.org/package=networktools}

Jones, P. J., Mair, P., & McNally, R. (2018).
Visualizing psychological networks: A tutorial in R.
\emph{Frontiers in Psychology}, \emph{9}, 1742.
\href{https://doi.org/10.3389/fpsyg.2018.01742}{10.3389/fpsyg.2018.01742}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
