% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partboot.test.R
\name{partboot.test}
\alias{partboot.test}
\title{Test for partboot}
\usage{
partboot.test(..., groups = NULL)
}
\arguments{
\item{...}{Objects from \code{\link[SemNeT]{partboot}}}

\item{groups}{Character.
Labels for groups in the order they were entered
in \code{\link[SemNeT]{partboot}} (e.g.,
\code{data} = first,
\code{paired} = second)}
}
\value{
Returns a list containing the objects:

\item{ASPL}{Test statistics for each percentage of nodes remaining for ASPL}

\item{CC}{Test statistics for each percentage of nodes remaining for CC}

\item{Q}{Test statistics for each percentage of nodes remaining for Q}

The matrix in each object has the following columns:

\item{t-statistic}{Statistic from the \code{\link{t.test}}}

\item{df}{Degrees of freedom}

\item{p-value}{\emph{p}-value with values equal to \code{0} being \emph{p} < .001}

\item{d}{Cohen's \emph{d}}

\item{CI95.lower}{Lower bound of the 95 percent confidence interval}

\item{CI95.upper}{Upper bound of the 95 percent confidence interval}

\item{Direction}{Direction of the effect. The argument \code{groups} will
specify specifically which group is higher or lower on the measure. If no
groups are input, then \code{"d"} and \code{"p"} are used to represent
\code{data} and \code{paired} samples from \code{\link[SemNeT]{partboot}}, respectively}

Row names refer to the percentage of nodes remaining in bootstrapped networks
}
\description{
Bootstraps (without replacement) the nodes in the network and computes global network characteristics
}
\examples{
# Simulate Dataset
one <- sim.fluency(20)
two <- sim.fluency(20)
\donttest{
# Run partial bootstrap networks
two.result <- partboot(data = one, paired = two, percent = .50, iter = 1000,
sim = "cosine", cores = 2)
}
# Compute tests
partboot.test(two.result, groups = c("One", "Two"))

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
