% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_outcome_modeler.R
\name{SensIAT_sim_outcome_modeler}
\alias{SensIAT_sim_outcome_modeler}
\title{Outcome Modeler for \code{SensIAT} Single Index Model.}
\usage{
SensIAT_sim_outcome_modeler(
  formula,
  data,
  kernel = "K2_Biweight",
  method = "nmk",
  id = ..id..,
  ...
)
}
\arguments{
\item{formula}{The outcome model formula}

\item{data}{The data to fit the outcome model to.
Should only include follow-up data, i.e. time > 0.}

\item{kernel}{The kernel to use for the outcome model.}

\item{method}{The optimization method to use for the outcome model, either \code{"optim"}, \code{"nlminb"}, or \code{"nmk"}.}

\item{id}{The patient identifier variable for the data.}

\item{...}{Currently ignored, included for future compatibility.}
}
\value{
Object of class \code{SensIAT::Single-index-outcome-model} which contains the outcome model portion.
}
\description{
Outcome Modeler for \code{SensIAT} Single Index Model.
}
\examples{
\donttest{
model <-
    fit_SensIAT_within_group_model(
        group.data = SensIAT_example_data,
        outcome_modeler = SensIAT_sim_outcome_modeler,
        alpha = c(-0.6, -0.3, 0, 0.3, 0.6),
        id.var = Subject_ID,
        outcome.var = Outcome,
        time.var = Time,
        End = 830,
        knots = c(60,60,60,60,260,460,460,460,460),
    )
}
}
