% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCORI_fulldata_model.R,
%   R/PCORI_within_group_model.R
\name{fit_SensIAT_fulldata_model}
\alias{fit_SensIAT_fulldata_model}
\alias{fit_SensIAT_within_group_model}
\title{Produce fitted model for group (treatment or control)}
\usage{
fit_SensIAT_fulldata_model(data, trt, ...)

fit_SensIAT_within_group_model(
  group.data,
  outcome_modeler,
  id,
  outcome,
  time,
  knots,
  alpha = 0,
  End = NULL,
  intensity.args = list(),
  outcome.args = list(),
  influence.args = list(),
  spline.degree = 3,
  add.terminal.observations = TRUE
)
}
\arguments{
\item{data}{the full data set.}

\item{trt}{an expression that determine what is treated as the treatment.
Everything not treatment is considered control.}

\item{...}{common arguments passed to \code{fit_SensIAT_within_group_model}.}

\item{group.data}{The data for the group that is being analyzed.
Preferably passed in as a single \code{tibble} that internally is
subsetted/filtered as needed.}

\item{outcome_modeler}{A separate function that may be swapped out to switch
between negative-binomial, single index model, or another we will
dream up in the future.}

\item{id}{The variable that identifies the patient.}

\item{outcome}{The variable that contains the outcome.}

\item{time}{The variable that contains the time.}

\item{knots}{knot locations for defining the spline basis.}

\item{alpha}{The sensitivity parameter.}

\item{End}{The end time for this data analysis, we need to set the default value as the
max value of the time.}

\item{intensity.args}{A list of optional arguments for intensity model.
See the Intensity Arguments section.}

\item{outcome.args}{parameters as needed passed into the \code{outcome_modeler}.
One special element may be \code{'model.modifications'} which, if present,
should be a formula that will be used to modify the outcome model per, \link{update.formula}.}

\item{influence.args}{A list of optional arguments used when computing the influence.
See the Influence Arguments section.}

\item{spline.degree}{The degree of the spline basis.}

\item{add.terminal.observations}{Logical indicating whether to add terminal
observations to the data.  If TRUE, data may not contain any \code{NA}s.
if FALSE, data will be assumed to already include the terminal
observations}
}
\value{
a list with class \code{SensIAT-fulldata-fitted-model} with two components,
\code{control} and \code{treatment}, each of which is an independently fitted
\code{SensIAT-within-group-fitted-model} fit with the fit_within_group_model
function.

Should return everything needed to define the fit of the model.
This can then be used for producing the estimates of mean, variance,
and in turn treatment effect.  For the full data model a list with two
models one each for the treatment and control groups.
}
\description{
Produces a fitted model that may be used to produce estimates of mean and
variance for the given group.
}
\details{
This function should be agnostic to whether it is being provided a
treatment or control group.
}
\section{Functions}{
\itemize{
\item \code{fit_SensIAT_fulldata_model()}: Fit the sensitivity analysis for both treatment and control groups.

}}
\section{Intensity Arguments}{

The \code{intensity.args} list may contain the following elements:
\itemize{
\item \strong{\code{model.modifications}} A formula that will be used to modify the intensity model from it's default, per \link{update.formula}.
\item \strong{\code{kernel}} The kernel function for the intensity model. Default is the Epanechnikov kernel.
\item \strong{\code{bandwidth}} The bandwidth for the intensity model kernel.
}
}

\section{Influence Arguments}{


The \code{influence.args} list may contain the following elements:
\itemize{
\item \strong{\code{method}} The method for integrating, adaptive or fixed quadrature. Default is \code{'adaptive'}.
\item \strong{\code{tolerance}} The tolerance when using adaptive quadrature.
\item \strong{\code{delta}} The bin width for fixed quadrature.
\item \strong{\code{resolution}} alternative to \code{delta} by specifying the number of bins.
\item \strong{\code{fix_discontinuity}} Whether to account for the discontinuity in the influence at observation times.
}
}

\examples{
\donttest{
model <-
    fit_SensIAT_within_group_model(
        group.data = SensIAT_example_data,
        outcome_modeler = SensIAT_sim_outcome_modeler,
        alpha = c(-0.6, -0.3, 0, 0.3, 0.6),
        id = Subject_ID,
        outcome = Outcome,
        time = Time,
        End = 830,
        knots = c(60,260,460),
    )
}
}
