% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.kataegis.R
\name{test.kataegis}
\alias{test.kataegis}
\title{Test Kataegis}
\usage{
test.kataegis(chromosome.num, somatic, units, exprobntcx, output.name, ref.dir,
  chromosome.length.file)
}
\arguments{
\item{chromosome.num}{Chromosome}

\item{somatic}{Data frame of somatic variants}

\item{units}{Base window size}

\item{exprobntcx}{Expected probability for each trinucleotide and total number of tcx}

\item{output.name}{Name of the generated output directory.}

\item{ref.dir}{Path to a directory containing the reference genome.}

\item{chromosome.length.file}{A tab separated file containing the lengths of all chromosomes in the reference genome.}
}
\description{
Performs exact binomial test to test the deviation of the 32 tri-nucleotides counts from expected
}
\examples{
load(
	paste0(
		path.package("SeqKat"),
		"/extdata/test/somatic.rda"
		)
	);

load(
	paste0(
		path.package("SeqKat"),
		"/extdata/test/exprobntcx.rda"
		)
	);

example.chromosome.length.file <- paste0(
	path.package("SeqKat"),
	"/extdata/test/length_hg19_chr_test.txt"
	);

example.ref.dir <- paste0(
	path.package("SeqKat"),
	"/extdata/test/ref/"
	);

test.kataegis(
	4,
	somatic,
	2,
	exprobntcx,
	tempdir(),
	example.ref.dir,
	example.chromosome.length.file
	);
}
\author{
Fouad Yousif
}
