% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_rnaseq.R
\name{gen_rnaseq}
\alias{gen_rnaseq}
\title{Generate RNA-seq data from an underlying network}
\usage{
gen_rnaseq(n, network, reference = NULL, verbose = TRUE)
}
\arguments{
\item{n}{The number of samples to generate.}

\item{network}{A 'network' object or list of 'network' objects.}

\item{reference}{A data.frame containing reference gene expression data. Rows
should correspond to samples and columns to genes. If NULL, then the kidney 
dataset is used.}

\item{verbose}{Boolean indicator for message output.}
}
\value{
A list containing the simulated expression data and the reference 
dataset. If a list of networks were provided, then the results for
each network are returned as a list.
}
\description{
The expression data are generated based on the gene-gene associations of an
underlying network. An association structure is imposed by first generating 
data from a multivariate Gaussian distribution. Those data are then used to
sample from the empirical distribution of gene expression profiles in the 
reference dataset using the inverse transform method.
}
\examples{
nw <- random_network(10) # Create a random network with 10 nodes.
nw <- gen_partial_correlations(nw) # Add weights to connections in the network.
# If no reference is provided, the internal RNA-seq reference dataset is used.
x <- gen_rnaseq(20, nw)$x # Simulate 20 observations from the network.
}
