% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{update_module_with_random_weights}
\alias{update_module_with_random_weights}
\title{Generate small-world network structure for module}
\usage{
update_module_with_random_weights(
  module,
  rdist = function(n) {     runif(n, 0.5, 1) * (-1)^rbinom(n, 1, 0.5) },
  ...
)
}
\arguments{
\item{module}{The network_module object to modify.}

\item{rdist}{A distribution function that generates random numbers. The first
argument should specify the number of weights to generate. By default,
weights are generated uniformly from the set (-1, -0.5)U(0.5, 1).}

\item{...}{Additional parameters are ignored.}
}
\value{
An updated 'network_module' object.
}
\description{
The small-world network is generated using the Watts-Strogatz method.
See \code{\link[igraph:sample_smallworld]{watts.strogatz.game}} for details.
}
\examples{
# Create a random module. 
module <- random_module(1:10)
is_weighted(module)
# Add a random weight to each connection.
module <- update_module_with_random_weights(module)
is_weighted(module)
}
