% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceSpikeSlab.R
\name{SSS_discretize_Lambda}
\alias{SSS_discretize_Lambda}
\title{Given a prior Lambda on the alpha-parameter in the spike-and-slab model,
make a discretized version of Lambda that is only supported on a grid of
approximately m * sqrt(n) discrete values of alpha. This discretized
version of Lambda is required as input for
\code{\link{SSS_discrete_spike_slab}}.
NB Lambda needs to satisfy a technical condition from the
paper that guarantees its density does not vary too rapidly. For
Lambda=Beta(kappa,lambda) use \code{\link{SSS_discretize_Lambda_beta}}
instead.}
\usage{
SSS_discretize_Lambda(m = 20, n, log_Lambda_cdf)
}
\arguments{
\item{m}{A multiplier for the number of discretization points}

\item{n}{The sample size}

\item{log_Lambda_cdf}{A function that takes as input a value of alpha and
calculates the log of the cumulative distribution function of Lambda at alpha}
}
\value{
List (alpha_grid, log_probs), where alpha_grid is a vector with the
generated grid points, and log_probs are the logs of the prior probabilities
of these grid points for the discretized Lambda prior.
}
\description{
Given a prior Lambda on the alpha-parameter in the spike-and-slab model,
make a discretized version of Lambda that is only supported on a grid of
approximately m * sqrt(n) discrete values of alpha. This discretized
version of Lambda is required as input for
\code{\link{SSS_discrete_spike_slab}}.
NB Lambda needs to satisfy a technical condition from the
paper that guarantees its density does not vary too rapidly. For
Lambda=Beta(kappa,lambda) use \code{\link{SSS_discretize_Lambda_beta}}
instead.
}
