% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{FindMarkers}
\alias{FindMarkers}
\title{Gene expression markers of identity classes}
\usage{
FindMarkers(object, ident.1, ident.2 = NULL, genes.use = NULL,
  thresh.use = 0.25, test.use = "bimod", min.pct = 0.1,
  min.diff.pct = -Inf, print.bar = TRUE, only.pos = FALSE,
  max.cells.per.ident = Inf, random.seed = 1, latent.vars = "nUMI",
  min.cells = 3)
}
\arguments{
\item{object}{Seurat object}

\item{ident.1}{Identity class to define markers for}

\item{ident.2}{A second identity class for comparison. If NULL (default) -
use all other cells for comparison.}

\item{genes.use}{Genes to test. Default is to use all genes}

\item{thresh.use}{Limit testing to genes which show, on average, at least
X-fold difference (log-scale) between the two groups of cells. Default is 0.25
Increasing thresh.use speeds up the function, but can miss weaker signals.}

\item{test.use}{Denotes which test to use. Seurat currently implements
"bimod" (likelihood-ratio test for single cell gene expression, McDavid et
al., Bioinformatics, 2013, default), "roc" (standard AUC classifier), "t"
(Students t-test), and "tobit" (Tobit-test for differential gene expression,
as in Trapnell et al., Nature Biotech, 2014), 'poisson', and 'negbinom'.
The latter two options should only be used on UMI datasets, and assume an underlying
poisson or negative-binomial distribution}

\item{min.pct}{- only test genes that are detected in a minimum fraction of min.pct cells
in either of the two populations. Meant to speed up the function by not testing genes that are very infrequently expressed. Default is 0.1}

\item{min.diff.pct}{- only test genes that show a minimum difference in the fraction of detection between the two groups. Set to -Inf by default}

\item{print.bar}{Print a progress bar once expression testing begins (uses pbapply to do this)}

\item{only.pos}{Only return positive markers (FALSE by default)}

\item{max.cells.per.ident}{Down sample each identity class to a max number. Default is no downsampling. Not activated by default (set to Inf)}

\item{random.seed}{Random seed for downsampling}

\item{latent.vars}{Variables to test}

\item{min.cells}{Minimum number of cells expressing the gene in at least one of the two groups}
}
\value{
Matrix containing a ranked list of putative markers, and associated statistics (p-values, ROC score, etc.)
}
\description{
Finds markers (differentially expressed genes) for identity classes
}
\examples{
markers <- FindMarkers(object = pbmc_small, ident.1 = 3)
head(markers)

}
