% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{VizDimReduction}
\alias{VizDimReduction}
\title{Visualize Dimensional Reduction genes}
\usage{
VizDimReduction(object, reduction.type = "pca", dims.use = 1:5,
  num.genes = 30, use.full = FALSE, font.size = 0.5, nCol = NULL,
  do.balanced = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{reduction.type}{Reduction technique to visualize results for}

\item{dims.use}{Number of dimensions to display}

\item{num.genes}{Number of genes to display}

\item{use.full}{Use reduction values for full dataset (i.e. projected dimensional reduction values)}

\item{font.size}{Font size}

\item{nCol}{Number of columns to display}

\item{do.balanced}{Return an equal number of genes with + and - scores. If FALSE (default), returns
the top genes ranked by the scores absolute values}
}
\value{
Graphical, no return value
}
\description{
Visualize top genes associated with reduction components
}
\examples{
VizDimReduction(object = pbmc_small)

}
