% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{FeatureHeatmap}
\alias{FeatureHeatmap}
\title{Vizualization of multiple features}
\usage{
FeatureHeatmap(object, features.plot, dim.1 = 1, dim.2 = 2,
  idents.use = NULL, pt.size = 2, cols.use = c("grey", "red"),
  pch.use = 16, reduction.use = "tsne", group.by = NULL,
  sep.scale = FALSE, do.return = FALSE, min.exp = -Inf, max.exp = Inf,
  rotate.key = FALSE, plot.horiz = FALSE, key.position = "right")
}
\arguments{
\item{object}{Seurat object}

\item{features.plot}{Vector of features to plot}

\item{dim.1}{Dimension for x-axis (default 1)}

\item{dim.2}{Dimension for y-axis (default 2)}

\item{idents.use}{Which identity classes to display (default is all identity
classes)}

\item{pt.size}{Adjust point size for plotting}

\item{cols.use}{Ordered vector of colors to use for plotting. Default is
heat.colors(10).}

\item{pch.use}{Pch for plotting}

\item{reduction.use}{Which dimensionality reduction to use. Default is
"tsne", can also be "pca", or "ica", assuming these are precomputed.}

\item{group.by}{Group cells in different ways (for example, orig.ident)}

\item{sep.scale}{Scale each group separately. Default is FALSE.}

\item{do.return}{Return the ggplot2 object}

\item{min.exp}{Min cutoff for scaled expression value, supports quantiles in the form of 'q##' (see FeaturePlot)}

\item{max.exp}{Max cutoff for scaled expression value, supports quantiles in the form of 'q##' (see FeaturePlot)}

\item{rotate.key}{rotate the legend}

\item{plot.horiz}{rotate the plot such that the features are columns, groups are the rows}

\item{key.position}{position of the legend ("top", "right", "bottom", "left")}
}
\value{
No return value, only a graphical output
}
\description{
Similar to FeaturePlot, however, also splits the plot by visualizing each
identity class separately.
}
\details{
Particularly useful for seeing if the same groups of cells co-exhibit a
common feature (i.e. co-express a gene), even within an identity class. Best
understood by example.
}
\examples{
pbmc_small
FeatureHeatmap(object = pbmc_small, features.plot = "PC1")

}
\seealso{
\code{\link{FeaturePlot}}
}
